/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.log.ILogListener;
import net.ftb.log.LogEntry;
import net.ftb.log.LogLevel;
import net.ftb.log.LogSource;
import net.ftb.log.LogType;
import net.ftb.log.Logger;
import net.ftb.tools.PastebinPoster;
import net.ftb.util.GameUtils;
import net.ftb.util.OSUtils;

public class LauncherConsole
extends JFrame
implements ILogListener {
    private final JEditorPane displayArea;
    private final HTMLEditorKit kit;
    private HTMLDocument doc;
    private final JComboBox logTypeComboBox;
    private LogType logType = LogType.MINIMAL;
    private final JComboBox logSourceComboBox;
    private LogSource logSource = LogSource.ALL;
    private LogLevel logLevel = LogLevel.INFO;
    private JButton killMCButton;

    public LauncherConsole() {
        this.setTitle("Feed The Beast Launcher " + I18N.getLocaleString("CONSOLE_TITLE"));
        this.setMinimumSize(new Dimension(800, 400));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        panel.setLayout(new FlowLayout(0, 5, 5));
        JButton pastebin = new JButton(I18N.getLocaleString("CONSOLE_PASTEBIN"));
        pastebin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane pane = new JOptionPane("The log will be copied to your clipboard and pastebin.com will be opened now");
                Object[] options = new String[]{"Yes do it", "Cancel"};
                pane.setOptions(options);
                JDialog dialog = pane.createDialog(new JFrame(), I18N.getLocaleString("CONSOLE_PASTEBIN"));
                dialog.setVisible(true);
                Object obj = pane.getValue();
                int result = -1;
                for (int i = 0; i < options.length; ++i) {
                    if (!options[i].equals(obj)) continue;
                    result = i;
                }
                if (result == 0) {
                    PastebinPoster thread = new PastebinPoster();
                    thread.start();
                }
            }
        });
        panel.add(pastebin);
        JButton clipboard = new JButton(I18N.getLocaleString("CONSOLE_COPYCLIP"));
        clipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane pane = new JOptionPane(I18N.getLocaleString("CONSOLE_CLIP_CONFIRM"));
                Object[] options = new String[]{I18N.getLocaleString("MAIN_YES"), I18N.getLocaleString("MAIN_CANCEL")};
                pane.setOptions(options);
                JDialog dialog = pane.createDialog(new JFrame(), I18N.getLocaleString("CONSOLE_COPYCLIP"));
                dialog.setVisible(true);
                Object obj = pane.getValue();
                int result = -1;
                for (int i = 0; i < options.length; ++i) {
                    if (!options[i].equals(obj)) continue;
                    result = i;
                }
                if (result == 0) {
                    StringSelection stringSelection = new StringSelection("FTB Launcher logs:\n" + Logger.getLogs());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            }
        });
        panel.add(clipboard);
        this.logTypeComboBox = new JComboBox<LogType>(LogType.values());
        this.logTypeComboBox.setSelectedItem((Object)this.logType);
        this.logTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LauncherConsole.this.logType = (LogType)((Object)LauncherConsole.this.logTypeComboBox.getSelectedItem());
                switch (LauncherConsole.this.logType) {
                    case MINIMAL: {
                        LauncherConsole.this.logLevel = LogLevel.INFO;
                        break;
                    }
                    case EXTENDED: {
                        LauncherConsole.this.logLevel = LogLevel.INFO;
                        break;
                    }
                    case DEBUG: {
                        LauncherConsole.this.logLevel = LogLevel.DEBUG;
                    }
                }
                LauncherConsole.this.refreshLogs();
            }
        });
        panel.add(this.logTypeComboBox);
        this.logSourceComboBox = new JComboBox<LogSource>(LogSource.values());
        this.logSourceComboBox.setSelectedItem((Object)this.logSource);
        this.logSourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LauncherConsole.this.logSource = (LogSource)((Object)LauncherConsole.this.logSourceComboBox.getSelectedItem());
                LauncherConsole.this.refreshLogs();
            }
        });
        panel.add(this.logSourceComboBox);
        JButton ircButton = new JButton(I18N.getLocaleString("CONSOLE_SUPPORT"));
        ircButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OSUtils.browse("http://support.feed-the-beast.com/");
            }
        });
        panel.add(ircButton);
        this.killMCButton = new JButton(I18N.getLocaleString("KILL_MC"));
        this.killMCButton.setEnabled(false);
        this.killMCButton.setVisible(true);
        this.killMCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameUtils.killMC();
            }
        });
        panel.add(this.killMCButton);
        this.displayArea = new JEditorPane("text/html", "");
        this.displayArea.setEditable(false);
        this.kit = new HTMLEditorKit();
        this.displayArea.setEditorKit(this.kit);
        DefaultCaret caret = (DefaultCaret)this.displayArea.getCaret();
        caret.setUpdatePolicy(2);
        JScrollPane scrollPane = new JScrollPane(this.displayArea);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.getContentPane().add(scrollPane);
        this.pack();
        this.refreshLogs();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Logger.removeListener(LaunchFrame.con);
                if (LaunchFrame.trayMenu != null) {
                    LaunchFrame.trayMenu.updateShowConsole(false);
                }
            }
        });
    }

    private synchronized void refreshLogs() {
        this.doc = new HTMLDocument();
        this.displayArea.setDocument(this.doc);
        List<LogEntry> entries = Logger.getLogEntries();
        StringBuilder logHTML = new StringBuilder();
        for (LogEntry entry : entries) {
            if (this.logSource != LogSource.ALL && entry.source != this.logSource || this.logLevel != LogLevel.DEBUG && !this.logLevel.includes(entry.level)) continue;
            logHTML.append(this.getMessage(entry));
        }
        this.addHTML(logHTML.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHTML(String html) {
        HTMLEditorKit hTMLEditorKit = this.kit;
        synchronized (hTMLEditorKit) {
            try {
                this.kit.insertHTML(this.doc, this.doc.getLength(), html, 0, 0, null);
            }
            catch (BadLocationException ignored) {
                Logger.logError(ignored.getMessage(), ignored);
            }
            catch (IOException ignored) {
                Logger.logError(ignored.getMessage(), ignored);
            }
            this.displayArea.setCaretPosition(this.displayArea.getDocument().getLength());
        }
    }

    public void scrollToBottom() {
        this.displayArea.setCaretPosition(this.displayArea.getDocument().getLength());
    }

    private String getMessage(LogEntry entry) {
        String color = "white";
        switch (entry.level) {
            case ERROR: {
                color = "#FF7070";
                break;
            }
            case WARN: {
                color = "yellow";
            }
            case INFO: {
                break;
            }
            case DEBUG: {
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
        return "<font color=\"" + color + "\">" + entry.toString(this.logType).replace("<", "&lt;").replace(">", "&gt;").trim().replace("\r\n", "\n").replace("\n", "<br/>") + "</font><br/>";
    }

    public void minecraftStarted() {
        this.killMCButton.setEnabled(true);
    }

    public void minecraftStopped() {
        this.killMCButton.setEnabled(false);
    }

    @Override
    public void onLogEvent(LogEntry entry) {
        if (!(this.logSource != LogSource.ALL && entry.source != this.logSource || this.logLevel != LogLevel.DEBUG && !this.logLevel.includes(entry.level))) {
            final LogEntry entry_ = entry;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LauncherConsole.this.addHTML(LauncherConsole.this.getMessage(entry_));
                }
            });
        }
    }
}

